
(* Slave the axes of a slave xbot to the axes of one or more master xbots via cams *)
FUNCTION_BLOCK PMC_CamMotion
	PMC_CmdProcessor(Execute, 0,FALSE, PM_Controller, PMCFuncInfo, Done,DummyDone, Busy, Error, ErrorID, Aborted);

	IF PMCFuncInfo.SendToPMC THEN
		CASE PMCFuncInfo.MsgPartNStatus OF
			1:  (* Statement section case 1            *)
				(*SendToPMCDataRegion//*)
				(*Sending Command to PMC*)
				(* read current heart beat of field bus*)
				memcpy(pDest := ADR(cmdHB),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_CMDC_OFFSET,length := 1);
				(*update command heart beat*)
				cmdHB := cmdHB + 1;
				cmdHB := cmdHB AND 255;
				(*--------------write command info*)
				(*command ID*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_CMDID_OFFSET,pSrc := ADR(cmdID),length := 2);
				(*command label*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_CMDLB_OFFSET,pSrc := ADR(cmdLB),length := 2);
				(*Control Level:*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 3,pSrc := ADR(Level),length := 1);
				(*Slave XBOT ID:*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 4,pSrc := ADR(SlaveXID),length := 1);
				IF nAxis > maxNAxis THEN
					(* Statement section IF*)
					axisNum := SINT_TO_USINT(maxNAxis);
				ELSE
					axisNum := nAxis;
				END_IF;
				(*Number of axes:*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 5,pSrc := ADR(axisNum),length := 1);
				FOR xIndex := 0 TO USINT_TO_SINT(axisNum - 1) DO
					(* Statement section FOR*)
					(*Slave axis ID: *)
					memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 6 + xIndex * 4,pSrc := ADR(SlaveAID[xIndex]),length := 1);
					(*Cam ID: *)
					memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 7 + xIndex * 4,pSrc := ADR(camID[xIndex]),length := 1);
					(*Master XBOT ID: *)
					memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 8 + xIndex * 4,pSrc := ADR(MasterXID[xIndex]),length := 1);
					(*Master Axis ID: *)
					memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 9 + xIndex * 4,pSrc := ADR(MasterAID[xIndex]),length := 1);
				END_FOR;
			
				(*write command heart beat*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_CMDC_OFFSET,pSrc := ADR(cmdHB),length := 1);
				(*SendToPMCDataRegionEnd//*)
				PMCFuncInfo.MsgPartNStatus := 0;   (*finished sending, report all done*)
			ELSE  (* Statement section ELSE*)
				PMCFuncInfo.MsgPartNStatus := -2;   (*error detected, invalid part*)
		END_CASE;
	END_IF;

	IF PMCFuncInfo.ReadFromPMC THEN
		CASE PMCFuncInfo.MsgPartNStatus OF
			1:
				(*ReadFromPMCDataRegion//*)
			
				(*ReadFromPMCDataRegionEnd//*)
				PMCFuncInfo.MsgPartNStatus := 0;  (*finished sending, report all done*)
			ELSE
				PMCFuncInfo.MsgPartNStatus := -2;   (*wrong part number*)
		END_CASE;
	END_IF;

	IF PMCFuncInfo.SendToPMC OR PMCFuncInfo.ReadFromPMC THEN
		PMC_CmdProcessor(Execute, 1,FALSE, PM_Controller, PMCFuncInfo, Done,DummyDone, Busy, Error, ErrorID, Aborted);
	END_IF;

	(*timeout check, overrides the cmdprocessor outputs in case it has implementation errors. Hard timeout check*)
	IF Execute = TRUE AND Busy = TRUE THEN
		timeout := timeout + 1;
		IF timeout > PM_Controller.PMC_Constants.PMC_TIMEOUT THEN
			ErrorID := 8201;    (*timeout error id*)
			Error := TRUE;
			Busy := FALSE;
			Aborted := FALSE;
			Done := FALSE;
			(*the command processor will close the ticket,*)
			PMCFuncInfo.CmdSta := 30; (*idle state, and not change any outputs such as ErrorID or Eroor*)
			PMC_CmdProcessor(Execute, 2,FALSE, PM_Controller, PMCFuncInfo, Done,DummyDone, Busy, Error, ErrorID, Aborted);
		END_IF;
	ELSE
		timeout := 0;
	END_IF;
END_FUNCTION_BLOCK
